<?php
require_once __DIR__ . '/classconexion.php';
require_once __DIR__ . '/../vendor/autoload.php';

use GuzzleHttp\Client;
use BigFish\PDF417\PDF417;
use BigFish\PDF417\Renderers\ImageRenderer;
use BigFish\PDF417\Renderers\SvgRenderer;
//use \SimpleXMLElement;

class Lioren
{
   const TIPO_BOLETA  = 'BOLETA';
   const TIPO_FACTURA = 'FACTURA';
   protected $con;
   public function __construct()
   {
      $this->con = (new Db)->dbh;
   }
   public function enviarVenta($codigoVenta)
   {
      $venta = $this->getVenta($codigoVenta);
      if ($venta->sucursal->lioren_token && $venta->sucursal->lioren_token !== '') {
         if (self::TIPO_BOLETA == $venta->tipodocumento) {
            $this->enviarBoleta($venta);
         }
         if (self::TIPO_FACTURA == $venta->tipodocumento) {
            $this->enviarFactura($venta);
         }
         $venta = $this->getVenta($codigoVenta);
         return $venta;
      }
   }
   private function enviarFactura($venta)
   {
      $cliente = $venta->cliente;
      $data    = [
         'emisor'   => [
            'tipodoc' => '33',
            'fecha'   => date('Y-m-d', strtotime($venta->fechaventa)),
         ],
         'receptor' => [
            'rut'       => $cliente->dnicliente,
            'rs'        => $cliente->razoncliente,
            'giro'      => $cliente->girocliente,
            'comuna'    => (int) $cliente->codcomuna,
            'ciudad'    => (int) $cliente->codciudad,
            'direccion' => $cliente->direccliente,
         ],
         'detalles' => array_map(function ($value) {
            $exento = $value->iva_lioren != 'SI' ? true : false;
            $precio = (float) $value->precioventa ;
            if(!$exento) $precio /= 1.19;
            return [
               // 'codigo'   => $value->codproducto,
               'nombre'   => $value->producto,
               'cantidad' => (int) $value->cantventa,
               'precio'   => $precio,
               'exento'   => $exento,
            ];
         }, $venta->detalles),
         'expects'  => 'xml',
      ];
      $responseBody = $this->enviar($data, $venta->sucursal->lioren_token, true);
      $folio   = $responseBody['folio'];
      $xml     = $responseBody['xml'];
      $trackid = $responseBody['id'];
      $name    = "FACTURA_{$folio}.xml";
      file_put_contents(__DIR__ . "/../sii/$name", base64_decode($xml));
      $this->updateVenta(['codfactura' => "{$folio}", 'codautorizacion' => $trackid], $venta->codventa);
   }

   private function enviarBoleta($venta)
   {
      $data = [
         'emisor'   => [
            'tipodoc'  => '39',
            'servicio' => 3,
         ],
         'receptor' => [],
         'detalles' => array_map(function ($item) {
            return [
               // 'codigo'   => $item->codproducto,
               'nombre'   => $item->producto,
               'cantidad' => $item->cantventa,
               'precio'   => (float) $item->precioventa,
               'exento'   => $item->iva_lioren != 'SI' ? true : false,
            ];
         }, $venta->detalles),
         'expects'  => 'xml',
      ];

      $responseBody = $this->enviar($data, $venta->sucursal->lioren_token, false);
      $folio        = $responseBody['folio'];
      $xml          = $responseBody['xml'];
      $name         = "BOLETA_{$folio}.xml";
      file_put_contents(__DIR__ . "/../sii/$name", base64_decode($xml));
      $this->updateVenta(['codfactura' => "{$folio}"], $venta->codventa);
   }

   private function enviar($data, $accessToken, $factura)
   {
      $client   = new Client();
      $response = $client->post(
         $factura ? 'https://www.lioren.cl/api/dtes' : 'https://www.lioren.cl/api/boletas',
         [
            'headers' => [
               'Accept'        => 'application/json',
               'Authorization' => 'Bearer ' . $accessToken,
               'Content-Type'  => 'application/json',
            ],
            'body' => json_encode($data),
         ]
      );
      $responseBody = json_decode((string) $response->getBody(), true);
      if (isset($responseBody['errors'])) {
         http_response_code(400);
         die(json_encode([
            'message' => current($responseBody['errors']),
            'errors'  => $responseBody['errors']
         ], false));
      }
      return $responseBody;
   }

   private function updateVenta(array $values, $codventa)
   {
      $sql = join(',', array_map(function ($key, $value) {
         return "{$key}='{$value}'";
      }, array_keys($values), $values));
      $sql = "UPDATE ventas SET $sql WHERE codventa='$codventa'";
      return $this->con->exec($sql);
   }

   private function getVenta($codigoVenta)
   {
      $sql            = "SELECT * FROM ventas WHERE codventa=$codigoVenta";
      $venta          = $this->con->query($sql)->fetchObject();
      $venta->cliente = null;
      if ($venta->codcliente != '0') {
         $sql = "SELECT c.*, com.codcomuna, ciu.codciudad FROM clientes c
			INNER JOIN comunas com on com.id_comuna=c.id_comuna
			INNER JOIN ciudades ciu on ciu.id_ciudad=c.id_ciudad
			WHERE codcliente='{$venta->codcliente}'";
         $venta->cliente = $this->con->query($sql)->fetchObject();
      }
      $sql = "SELECT * FROM sucursales WHERE codsucursal={$venta->codsucursal}";
      $venta->sucursal = $this->con->query($sql)->fetchObject();
      //$sql             = "SELECT * FROM detalleventas WHERE codventa=$codigoVenta";
      /*$sql = "SELECT productos.iva_lioren, detalleventas.producto, detalleventas.cantventa, detalleventas.precioventa
       FROM detalleventas, productos WHERE productos.codproducto=detalleventas.codproducto and codventa=$codigoVenta ";*/
      $sql = "SELECT productos.ivaproducto AS iva_lioren, detalleventas.producto, detalleventas.cantventa, detalleventas.precioventa
       FROM detalleventas, productos WHERE productos.codproducto=detalleventas.codproducto AND codventa=$codigoVenta ";
      $venta->detalles = $this->con->query($sql)->fetchAll(PDO::FETCH_OBJ);
      return $venta;
   }

   static public function getTimbre($venta)
   {
      $xmlFileName = $venta['tipodocumento'] . '_' . $venta['codfactura'];
      $xmlPath = __DIR__ . "/../sii/$xmlFileName.xml";
      if (file_exists($xmlPath)) {
         $xml = file_get_contents($xmlPath);
         $oXml = new SimpleXMLElement($xml);
         $ted = $oXml->Documento->TED->asXML();

         $pdf417 = new PDF417();
         $pdf417->setColumns(10);
         $data = $pdf417->encode($ted);

         $imgPath = __DIR__ . "/../sii/$xmlFileName.png";
         $renderer = new ImageRenderer();
         $renderer->render($data)->save($imgPath);
         return $imgPath;
      }
      return null;
   }
}
