<?php
session_start();
require_once("classconexion.php");

class conectorDB extends Db
{
	public function __construct()
    {
        parent::__construct();
    } 	
	
	public function EjecutarSentencia($consulta, $valores = array()){  //funcion principal, ejecuta todas las consultas
		$resultado = false;
		
		if($statement = $this->dbh->prepare($consulta)){  //prepara la consulta
			if(preg_match_all("/(:\w+)/", $consulta, $campo, PREG_PATTERN_ORDER)){ //tomo los nombres de los campos iniciados con :xxxxx
				$campo = array_pop($campo); //inserto en un arreglo
				foreach($campo as $parametro){
					$statement->bindValue($parametro, $valores[substr($parametro,1)]);
				}
			}
			try {
				if (!$statement->execute()) { //si no se ejecuta la consulta...
					print_r($statement->errorInfo()); //imprimir errores
					return false;
				}
				$resultado = $statement->fetchAll(PDO::FETCH_ASSOC); //si es una consulta que devuelve valores los guarda en un arreglo.
				$statement->closeCursor();
			}
			catch(PDOException $e){
				echo "Error de ejecución: \n";
				print_r($e->getMessage());
			}	
		}
		return $resultado;
		$this->dbh = null; //cerramos la conexión
	} /// Termina funcion consultarBD
}/// Termina clase conectorDB

class Json
{
	private $json;

	################################ BUSQUEDA DE CIUDADES ################################
	public function BuscaCiudad($filtro){
		$consulta = "SELECT CONCAT(ciudad) as label, id_ciudad FROM ciudades WHERE CONCAT(ciudad) LIKE '%".$filtro."%' ORDER BY id_ciudad ASC LIMIT 0,10";
		$conexion = new conectorDB();
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE CIUDADES ################################

	################################ BUSQUEDA DE COMUNAS ################################
	public function BuscaComuna($filtro){
		$consulta = "SELECT CONCAT(comuna) as label, id_comuna, numero FROM comunas WHERE CONCAT(comuna) LIKE '%".$filtro."%' ORDER BY id_comuna ASC LIMIT 0,10";
		$conexion = new conectorDB();
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}
	################################ BUSQUEDA DE COMUNAS ################################

	public function BuscaCategoria($filtro){
    $consulta = "SELECT CONCAT(nomcategoria) as label, codcategoria FROM categorias WHERE CONCAT(nomcategoria) LIKE '%".$filtro."%' ORDER BY codcategoria ASC LIMIT 0,10";
			$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}

	public function BuscaMedidas($filtro){
    $consulta = "SELECT CONCAT(nommedida) as label, codmedida FROM medidas WHERE CONCAT(nommedida) LIKE '%".$filtro."%' ORDER BY codmedida ASC LIMIT 0,10";
			$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}

	public function BuscaIngrediente($filtro){

	if ($_SESSION["acceso"]=="administradorG") {

        $consulta = "SELECT CONCAT(ingredientes.nomingrediente) as label, ingredientes.idingrediente, ingredientes.codingrediente, ingredientes.nomingrediente, ingredientes.codmedida, ROUND(ingredientes.preciocompra, 0) preciocompra, ROUND(ingredientes.precioventa, 0) precioventa, ROUND(ingredientes.cantingrediente, 0) cantingrediente, ingredientes.ivaingrediente, ROUND(ingredientes.descingrediente, 0) descingrediente, ingredientes.lote, ingredientes.fechaexpiracion, medidas.nommedida 
        FROM ingredientes 
        LEFT JOIN medidas ON ingredientes.codmedida=medidas.codmedida
        WHERE CONCAT(codingrediente, '',nomingrediente, '',nommedida) LIKE '%".$filtro."%' ORDER BY ingredientes.codingrediente ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;

	} else {

        $consulta = "SELECT CONCAT(ingredientes.nomingrediente) as label, ingredientes.idingrediente, ingredientes.codingrediente, ingredientes.nomingrediente, ingredientes.codmedida, ROUND(ingredientes.preciocompra, 0) preciocompra, ROUND(ingredientes.precioventa, 0) precioventa, ROUND(ingredientes.cantingrediente, 0) cantingrediente, ingredientes.ivaingrediente, ROUND(ingredientes.descingrediente, 0) descingrediente, ingredientes.lote, ingredientes.fechaexpiracion, medidas.nommedida 
        FROM ingredientes 
        LEFT JOIN medidas ON ingredientes.codmedida=medidas.codmedida 
        WHERE CONCAT(codingrediente, '',nomingrediente, '',nommedida) LIKE '%".$filtro."%' AND ingredientes.codsucursal= '".strip_tags($_SESSION["codsucursal"])."' ORDER BY ingredientes.codingrediente ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	    }
	}


	public function BuscaProducto($filtro){

	if ($_SESSION["acceso"]=="administradorG") {

        $consulta = "SELECT CONCAT(productos.producto) as label, productos.idproducto, productos.codproducto, productos.producto, productos.codcategoria, ROUND(productos.preciocompra, 0) preciocompra, ROUND(productos.precioventa, 0) precioventa, ROUND(productos.existencia, 0) existencia, productos.ivaproducto, ROUND(productos.descproducto, 0) descproducto, productos.preparado, productos.lote, productos.fechaelaboracion, productos.fechaexpiracion, categorias.nomcategoria FROM productos 
        LEFT JOIN categorias ON productos.codcategoria=categorias.codcategoria
        WHERE CONCAT(codproducto, '',producto, '',nomcategoria, '',codigobarra) LIKE '%".$filtro."%' ORDER BY productos.codproducto ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;

	} else {

        $consulta = "SELECT CONCAT(productos.producto) as label, productos.idproducto, productos.codproducto, productos.producto, productos.codcategoria, ROUND(productos.preciocompra, 0) preciocompra, ROUND(productos.precioventa, 0) precioventa, ROUND(productos.existencia, 0) existencia, productos.ivaproducto, ROUND(productos.descproducto, 0) descproducto, productos.preparado, productos.lote, productos.fechaelaboracion, productos.fechaexpiracion, categorias.nomcategoria FROM productos 
        LEFT JOIN categorias ON productos.codcategoria=categorias.codcategoria
        WHERE CONCAT(codproducto, '',producto, '',nomcategoria, '',codigobarra) LIKE '%".$filtro."%' AND productos.codsucursal= '".strip_tags($_SESSION["codsucursal"])."' ORDER BY productos.codproducto ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	    }
	}

	public function BuscaCombo($filtro){

	if ($_SESSION["acceso"]=="administradorG") {

        $consulta = "SELECT CONCAT(combos.nomcombo) as label, combos.idcombo, combos.codcombo, combos.nomcombo, ROUND(combos.preciocompra, 0) preciocompra, ROUND(combos.precioventa, 0) precioventa, ROUND(combos.existencia, 0) existencia, combos.ivacombo, ROUND(combos.desccombo, 0) desccombo, combos.preparado 
        FROM combos
        WHERE CONCAT(codcombo, '',nomcombo) LIKE '%".$filtro."%' ORDER BY codcombo ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;

	} else {

        $consulta = "SELECT CONCAT(combos.nomcombo) as label, combos.idcombo, combos.codcombo, combos.nomcombo, ROUND(combos.preciocompra, 0) preciocompra, ROUND(combos.precioventa, 0) precioventa, ROUND(combos.existencia, 0) existencia, combos.ivacombo, ROUND(combos.desccombo, 0) desccombo, combos.preparado 
        FROM combos 
        WHERE CONCAT(codcombo, '',nomcombo) LIKE '%".$filtro."%' AND codsucursal= '".strip_tags($_SESSION["codsucursal"])."' ORDER BY codcombo ASC LIMIT 0,15";
        $conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;

	   }
	}

	public function BuscaClientes($filtro){
		$consulta = "SELECT
	CONCAT(if(clientes.documcliente='0','DOC.',documentos.documento), ': ',clientes.dnicliente, ': ',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente), ' | ',if(clientes.direccliente='','***',clientes.direccliente)) as label,  
	clientes.codcliente, 
	clientes.dnicliente,
	clientes.tipocliente,
	clientes.nomcliente,
	clientes.razoncliente,
	clientes.direccliente, 
	clientes.limitecredito,
	ROUND(SUM(if(pag.montocredito!='0',clientes.limitecredito-pag.montocredito,clientes.limitecredito)), 0) creditodisponible
    FROM
       clientes 
     LEFT JOIN documentos ON clientes.documcliente = documentos.coddocumento
     LEFT JOIN
       (SELECT
           codcliente, montocredito       
           FROM creditosxclientes) pag ON pag.codcliente = clientes.codcliente
           WHERE CONCAT(clientes.dnicliente, '',clientes.nomcliente, '',clientes.razoncliente, '',clientes.girocliente) LIKE '%".$filtro."%' 
           GROUP BY clientes.codcliente ASC";
		$conexion = new conectorDB;
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
	}


	public function BuscaFactura($filtro){
		$consulta = "SELECT CONCAT(tipodocumento, ' Nº ',codfactura, ': ',if(ventas.codcliente='0','CONSUMIDOR FINAL',if(clientes.nomcliente='',clientes.razoncliente,clientes.nomcliente))) as label, idventa, codventa, codfactura FROM ventas LEFT JOIN clientes ON ventas.codcliente = clientes.codcliente WHERE CONCAT(ventas.tipodocumento, ventas.codfactura) LIKE '%".$filtro."%' AND ventas.statusventa != 'ANULADA' AND ventas.codsucursal = '".strip_tags($_SESSION["codsucursal"])."' ORDER BY ventas.codfactura ASC LIMIT 0,10";
		$conexion = new conectorDB();
		$this->json = $conexion->EjecutarSentencia($consulta);
		return $this->json;
		
	}

}/// TERMINA CLASE  ///
?>